<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.9.1
 * @author Balu
 * @copyright Copyright (c) 2015 - 2019 Baluart.COM
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link http://easyforms.baluart.com/ Easy Forms
 */

namespace app\components\rules;

use Yii;
use Closure;
use yii\base\Action;
use yii\web\Response;

class RuleBuilderAction extends Action
{
    /**
     * @var Closure the output callback function
     */
    public $output;

    /**
     * @inheritdoc
     */
    public function run()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        $func = $this->output;
        $id = Yii::$app->request->get('id');
        if (is_callable($func)) {
            return $func($id);
        }
        return '';
    }


}
